@extends('layouts.app_investor')

@section('content')

<div class="container-full">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xxxl-12 col-xl-12 col-12">
                <div class="callout callout-success" style="display: none;">

                </div>

                <div class="row">
                    <div class="col-xl-6 col-12">
                        <div class="row">
                            <div class="col-lg-6 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="d-flex align-items-center">
                                            <div class="me-40 ms-35">
                                                <img src="{{ asset('admin/images/dash4.png') }}" alt="" class="w-100" />
                                            </div>
                                            <div>
                                                <h4 class="mb-0">Total Invested</h4>
                                                <h3 class="mb-0">{{ $totalInvestment }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="d-flex align-items-center">
                                            <div class="me-40 ms-35">
                                                <img src="{{ asset('admin/images/dash2.png') }}" alt="" class="w-100" />
                                            </div>
                                            <div>
                                                <h4 class="mb-0">Deals Finalized</h4>
                                                <h3 class="mb-0">{{ $dealsCount }}</h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-header with-border">
                                        <h4 class="box-title">Your Recent Deals</h4>
                                    </div>
                                    <div class="box-body">
                                        <div class="table-responsive">
                                            <table id="myinvestments" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                                <thead>
                                                    <tr>
                                                        <th>No</th>
                                                        <th>Deal Name</th>
                                                        <th>Deal Start Date</th>
                                                        <th>Deal Close Date</th>
                                                        <th>Total Invested</th>
                                                        <th>Investment Date</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($investments as $investment)
                                                    <tr>
                                                        <td>{{ $loop->iteration }}</td>
                                                        <td><strong><a href="{{ route('investor.deal.details', $investment->deal_id) }}">{{ $investment->deals->deal_name }}</a></strong></td>
                                                        <td>{{ $investment->deals->start_date }}</td>
                                                        <td>{{ $investment->deals->end_date }}</td>
                                                        <td>{{ $investment->invested_amt }}</td>
                                                        <td>{{ $investment->invested_on }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="col-xl-6 col-12">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="box-title">Total Investment</h4>
                            </div>
                            <div class="box-body">							
                                <div id="total_patient"></div>							
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>    
</div>		


<script>
    $(function () {


        var investorCounts = @json($investorCounts);
                var investmentSums = @json($investmentSums);

        var options = {
            series: [{
                    name: 'Total Investment',
                    type: 'column',
                    data: investmentSums
                }],
            chart: {
                height: 350,
                type: 'line',
                toolbar: {
                    show: false,
                }
            },
            stroke: {
                width: [0, 4],
                curve: 'smooth'
            },
            colors: ['#E7E4FF', '#5156be'],
            dataLabels: {
                enabled: false,
            },
            labels: ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'],
            legend: {
                show: true,
                position: 'top',
            }
        };

        var chart = new ApexCharts(document.querySelector("#total_patient"), options);
        chart.render();
    }); // End of use strict
</script>
<script src="{{ asset('assets/vendor_components/apexcharts-bundle/dist/apexcharts.js') }}"></script>
@endsection
