@extends('layouts.app_backend')

@section('content')

<div class="container-full">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xxxl-12 col-xl-12 col-12">
                <div class="callout callout-success" style="display: none;">

                </div>
                <div class="row">
                    <div class="col-lg-3 col-12">
                        <div class="box">
                            <a href="{{ route('list.investors') }}">
                                <div class="box-body">
                                    <div class="d-flex align-items-center">
                                        <div class="me-40">
                                            <img src="{{ asset('admin/images/dash1.png') }}" alt="" class="w-100" />
                                        </div>
                                        <div>
                                            <h4 class="mb-0">Total Investors</h4>
                                            <h3 class="mb-0">
                                                {{ $investorCount }}<span class="dash-card-smtitle">Till Date</span> 
                                                {{ $investorCountsCD }}<span class="dash-card-smtitle">Today</span>
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-12">
                        <div class="box">
                            <a href="{{ route('admin.deals.list') }}">
                                <div class="box-body">
                                    <div class="d-flex align-items-center">
                                        <div class="me-40">
                                            <img src="{{ asset('admin/images/dash2.png') }}" alt="" class="w-100" />
                                        </div>
                                        <div>
                                            <h4 class="mb-0">Total Deals</h4>
                                            <h3 class="mb-0">
                                                {{ $dealsCount }}<span class="dash-card-smtitle">Till Date</span> 
                                                {{ $dealsCountCD }}<span class="dash-card-smtitle">Today</span> 
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-40">
                                        <img src="{{ asset('admin/images/dash4.png') }}" alt="" class="w-100" />
                                    </div>
                                    <div>
                                        <h4 class="mb-0">Total Investment</h4>
                                        <h3 class="mb-0">{{ $totalInvestment }}</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="d-flex align-items-center">
                                    <div class="me-40">
                                        <img src="{{ asset('admin/images/dash3.png') }}" alt="" class="w-100" />
                                    </div>
                                    <div>
                                        <h4 class="mb-0">Admin Users</h4>
                                        <h3 class="mb-0">{{ $adminCount }}</h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-12">
                        <div class="box" style="min-height: 95%;">
                            <div class="box-header">
                                <h4 class="box-title">Registered Investor</h4>
                            </div>
                            <div class="box-body">										
                                <div id="appointment_overview" class="mt-145"></div>							
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-12">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="box-title">Total Investment</h4>
                            </div>
                            <div class="box-body">							
                                <div id="total_patient"></div>							
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Recent Investors</h4>
                            </div>
                            <div class="box-body no-padding">
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <tbody>
                                            <tr class="bg-info-light">
                                                <th>No</th>
                                                <th>Firstname</th>
                                                <th>Lastname</th>
                                                <th>Email Address</th>
                                                <th>Phone Number</th>
                                                <th>Registered On</th>
                                                <th>User Status</th>
                                            </tr>
                                            @foreach ($investors as $investor)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td><strong>{{ $investor->firstname }}</strong></td>
                                                <td><strong>{{ $investor->lastname }}</strong></td>
                                                <td>{{ $investor->email }}</td>
                                                <td>{{ $investor->phone }}</td>
                                                <td>{{ $investor->created_at->format('d-m-y') }}</td>
                                                <td>
                                                    <input type="hidden" id="status" name="status" value="{{ $investor->user->is_active }}">
                                                    <label class="switch">
                                                        <input type="checkbox" data-investor-id="{{ $investor->user->id }}" id="statusToggle" @if ($investor->user->is_active == 1) checked @endif onchange="updateInvestorStatus()">
                                                        <span class="slider"></span>
                                                    </label>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>	
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="box">
                            <div class="box-header with-border">
                                <h4 class="box-title">Recent Deals</h4>
                            </div>
                            <div class="box-body no-padding">
                                <div class="table-responsive">
                                    <table id="investorlist" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                        <thead>
                                            <tr class="bg-info-light">
                                                <th>No</th>
                                                <th>Deal Name</th>
                                                <th>Started On</th>
                                                <th>Total Investment</th>
                                                <th>Total Investors</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        <thead>
                                        <tbody>
                                            @foreach ($deals as $deal)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td><a href="{{ route('admin.deal.deatails', $deal->id) }}"><strong>{{ $deal->deal_name }}</strong></a></td>
                                                <td>{{ Carbon\Carbon::createFromFormat('Y-m-d', $deal->start_date)->format('d-m-Y') }}</td>
                                                <td>{{ number_format($deal->total_investment, 2) }}</td>
                                                <td>
                                                    @php
                                                    $formattedTotalInvestors = ($deal->total_investors > 0) ? $deal->total_investors : '0';
                                                    echo $formattedTotalInvestors; 
                                                    @endphp
                                                    Invested
                                                </td>
                                                <td>
                                                    <input type="hidden" id="status" name="status" value="{{ $deal->status }}">
                                                    <label class="switch">
                                                        <input type="checkbox" data-deal-id="{{ $deal->id }}" id="statusToggle" @if ($deal->status == 1) checked @endif onchange="updateDealStatus()">
                                                        <span class="slider"></span>
                                                    </label>
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <a href="{{ route('admin.deal.deatails', $deal->id) }}" class="waves-effect waves-circle btn btn-circle btn-info-light btn-xs me-5"><i class="fa-solid fa-eye"></i></a>
                                                        <a href="{{ route('admin.deals.edit', $deal->id) }}" class="waves-effect waves-circle btn btn-circle btn-success-light btn-xs me-5"><i class="fa fa-pencil"></i></a>
                                                        <button type="button" class="waves-effect waves-circle btn btn-circle btn-danger-light btn-xs" onclick="confirmDelete({{ $deal->id }})">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>	
                        </div>
                    </div>
                </div>

            </div>
        </div>			
    </section>
    <!-- /.content -->
</div>

<script>

    function updateInvestorStatus() {
    const statusToggle = document.getElementById("statusToggle");
    const currentStatus = statusToggle.checked ? 1 : 0;
    const investorId = statusToggle.getAttribute("data-investor-id");
    //console.log(dealId);

    const confirmed = confirm("Are you sure you want to update the deal status?");
    if (confirmed) {
    // Send an AJAX request to update the status in the database.
    updateStatusInDatabase(investorId, currentStatus);
    } else {
    // Restore the switch to its previous state.
    statusToggle.checked = !statusToggle.checked;
    }
    }
    function updateStatusInDatabase(investorId, newStatus) {
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    // Perform an AJAX request to update the status in the database.
    $.ajax({
    type: "POST",
            url: "{{ route('admin.user.status') }}", // Replace with the actual URL endpoint.
            data: {_token: csrfToken, investor_id: investorId, new_status: newStatus},
            success: function (response) {
            $('.callout-success').css("display", "block");
            $('.callout-success').text(response.message);
            setTimeout(function () {
            location.reload();
            }, 2000);
            },
            error: function (error) {
            // Handle error, if needed.
            console.error(error);
            }
    });
    }

    var userCounts = @json($userCounts);
    $(function () {
    var options = {
    series: [{
    name: 'Total',
            data: userCounts
    }],
            chart: {
            type: 'bar',
                    height: 205,
                    toolbar: {
                    show: false
                    }
            },
            colors: ['#5156be'],
            plotOptions: {
            bar: {
            horizontal: false,
                    columnWidth: '20%',
                    endingShape: 'rounded'
            },
            },
            dataLabels: {
            enabled: false
            },
            grid: {
            show: false,
            },
            stroke: {
            show: false,
                    width: 0,
                    colors: ['transparent']
            },
            xaxis: {
            categories: ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'],
            },
            yaxis: {
            axisBorder: {
            show: false
            },
                    axisTicks: {
                    show: false,
                    },
                    labels: {
                    show: false,
                    }

            },
            fill: {
            opacity: 1
            },
            tooltip: {
            y: {
            formatter: function (val) {
            return val + " User"
            }
            }
            }
    };
    var chart = new ApexCharts(document.querySelector("#appointment_overview"), options);
    chart.render();
    var investorCounts = @json($investorCounts);
    var investmentSums = @json($investmentSums);
    var options = {
    series: [{
    name: 'Total Investment',
            type: 'column',
            data: investmentSums
    }, {
    name: 'Investors',
            type: 'line',
            data: investorCounts
    }],
            chart: {
            height: 350,
                    type: 'line',
                    toolbar: {
                    show: false,
                    }
            },
            stroke: {
            width: [0, 4],
                    curve: 'smooth'
            },
            colors: ['#E7E4FF', '#5156be'],
            dataLabels: {
            enabled: false,
            },
            labels: ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'],
            legend: {
            show: true,
                    position: 'top',
            }
    };
    var chart = new ApexCharts(document.querySelector("#total_patient"), options);
    chart.render();
    }); // End of use strict

</script>
<script src="{{ asset('assets/vendor_components/apexcharts-bundle/dist/apexcharts.js') }}"></script>
<style>
    .dash-card-smtitle{
        margin-left: 5px;
        font-size: 12px;
        font-weight: 500;
        color: green;
    }
</style>
@endsection
