@extends('layouts.app_backend')

@section('content')
<!-- Main content -->
<section class="content">
    <div class="box">
        <div class="box-header with-border">
            <h4 class="box-title">ADD NEW REALTOR</h4>
        </div>

        <div class="box-body">
            <div class="row">
                <div class="col">
                    <form method="POST" action="{{ route('store.realtor') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 form-group">
                                <label for="firstname">First Name</label>
                                <input type="text" name="firstname" value="{{ old('firstname') }}" class="form-control @error('firstname') is-invalid @enderror"> 
                                @error('firstname')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <label for="lastname">Last Name</label>
                                <input type="text" name="lastname" value="{{ old('lastname') }}" class="form-control @error('lastname') is-invalid @enderror"> 
                                @error('lastname')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <label for="email">Email ID</label>
                                <input type="email" name="email" value="{{ old('email') }}" class="form-control @error('email') is-invalid @enderror"> 
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <label for="phone">Mobile Number</label>
                                <input type="text" name="phone" value="{{ old('phone') }}" class="form-control @error('phone') is-invalid @enderror"> 
                                @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <label for="location">Location</label>
                                <input type="text" name="location" value="{{ old('location') }}" class="form-control @error('location') is-invalid @enderror"> 
                                @error('location')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 form-group">
                                <label for="category">Category</label>
                                <select name="category" id="category" class="form-select @error('category') is-invalid @enderror">
                                    <option value="">Select Category</option>
                                    <option value="1" {{ old('location') == '1' ? 'selected' : '' }}>Individual</option>
                                    <option value="2" {{ old('location') == '2' ? 'selected' : '' }}>Corporate</option>
                                    <option value="3" {{ old('location') == '3' ? 'selected' : '' }}>Agency</option>
                                </select>
                                @error('category')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="text-xs-right">
                                <button type="submit" class="btn btn-info">ADD NEW REALTOR</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
    </div>
</section>

@endsection