@extends('layouts.app_backend')

@section('content')
<div class="container-fluid">
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="me-auto">
                <div class="d-inline-block align-items-center">
                    <nav>
                        <ol class="breadcrumb">
                            <li><a href="#">Home<i class="fa-solid fa-angles-right"></i></a></li>
                            <li><a href="#"> Investor<i class="fa-solid fa-angles-right"></i></a></li>
                            <li ><a href="#" class="breadcrumb-active">Add Tax Document</a></li>
                        </ol>
                    </nav>
                </div>
            </div>

        </div>
    </div>
    <section class="content">
        <div class="row justify-content-center">
            <div class="col-12 col-md-12 col-lg-5">
                <div class="box">
                    <div class="box-header with-border">
                        <h4 class="box-title">ADD INVESTOR TAXES</h4>
                    </div>

                    <div class="box-body ms-10">
                        <div class="row" id="document-rows">
                            <div class="col">
                                <form method="POST" action="{{ route('admin.investor.taxes') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row mb-2">
                                        <div class="col-md-9 form-group">
                                            <label for="investor_id">Select Investors</label>
                                            <select name="investor_id" id="investor_id" class="form-select form-control">
                                                <option value="">Select Investor</option>
                                                @foreach($investors as $investor)
                                                <option value="{{ $investor->id }} {{ old('investor_id') == $investor->id ? 'selected' : '' }}">{{ $investor->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('investor_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-md-9 form-group">
                                            <label for="deals">Select Deal</label>
                                            <select name="deal_id" id="deal_id" class="form-select form-control">
                                                <option value="">Select Deal</option>
                                                @foreach($deals as $deal)
                                                <option value="{{ $deal->id }} {{ old('deal_id') == $deal->id ? 'selected' : '' }}">{{ $deal->deal_name }}</option>
                                                @endforeach
                                            </select>
                                            @error('deal_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-2 documents-block">
                                        <div class="col-md-9 form-group">
                                            <label for="document_name">Fiscal Year</label>
                                            <input type="number" name="file_name[]" class="form-control" placeholder="2023"> 
                                        </div>
                                        <div class="col-md-9 form-group">
                                            <label for="document_file">Upload Tax File</label>
                                            <input type="file" name="tax_file[]" class="form-control"> 
                                        </div>
                                        <div class="col-md-3 form-group mt-4">
                                            <button type="button" id="more-documents" class="btn btn-info text-white"><i class="fa-solid fa-plus"></i></button>
                                            <button type="button" class="btn btn-danger remove-document text-white"><i class="fa-solid fa-trash"></i></button>
                                        </div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-success text-white">ADD DOCUMENTS</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
    $(document).ready(function () {
        // Event delegation for dynamically added "More documents" buttons
        $(document).on('click', '#more-documents', function () { // Change this line
            // Clone the documents-block div
            var clonedBlock = $('.documents-block:last').clone();

            // Clear input values in the cloned block
            clonedBlock.find('input').val('');
            clonedBlock.find('select').val('');

            // Add the cloned block after the last documents-block div
            $('.documents-block:last').after(clonedBlock);

            // Display the remove-document button in the cloned block
            clonedBlock.find('.remove-document').show();
        });

        // Event delegation for dynamically added "Remove documents" buttons
        $(document).on('click', '.remove-document', function () { // Change this line
            var result = confirm("Are you sure you want to remove this document?");
            if (result) {
                // Remove the corresponding documents-block div
                $(this).closest('.documents-block').remove();
            }
        });
    });
</script>
<style>
    .remove-document {
        display: none; /* Initially hidden */
    }
</style>
@endsection