@extends('layouts.app_backend')

@section('content')
<div class="container-fluid">
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="me-auto">
                <div class="d-inline-block align-items-center">
                    <nav>
                        <ol class="breadcrumb">
                            <li><a href="#">Home<i class="fa-solid fa-angles-right"></i></a></li>
                            <li><a href="#"> Deal<i class="fa-solid fa-angles-right"></i></a></li>
                            <li ><a href="#" class="breadcrumb-active">Add Investment</a></li>
                        </ol>
                    </nav>
                </div>
            </div>

        </div>
    </div>
    <section class="content">
        <div class="row justify-content-center">
            <div class="col-12 col-md-12 col-lg-8">
                <div>
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">ADD NEW DEAL</h4>
                        </div>

                        <div class="box-body ms-30">
                            <div class="row" id="investment-rows">
                                <div class="col">
                                    <form method="POST" action="{{ route('admin.deal.assign.investor') }}">
                                        @csrf
                                        <div class="row mb-2">
                                            <div class="col-md-9 form-group">
                                                <label for="deals">Select Deal</label>
                                                <select name="deal_id" id="deal_id" class="form-select form-control">
                                                    <option value="">Select Deal</option>
                                                    @foreach($deals as $deal)
                                                    <option value="{{ $deal->id }}{{ old('deal_id') == $deal->id ? 'selected' : '' }}">{{ $deal->deal_name }}</option>
                                                    @endforeach
                                                </select>
                                                @error('deal_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="row investment-block">
                                            <div class="col-md-9 form-group">
                                                <label for="investors">Investors</label>
                                                <select name="investor_id[]" id="investors" class="form-select form-control">
                                                    <option value="">Select Your Investor</option>
                                                    @foreach($investors as $investor)
                                                    <option value="{{ $investor->id }}{{ old('investor_id') == $investor->id ? 'selected' : '' }}">{{ $investor->name }}</option>
                                                    @endforeach
                                                </select>
                                                @error('investor_id')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-md-9 form-group">
                                                <label for="invested_amt">Amount Invested</label>
                                                <input type="text" name="invested_amt[]" class="form-control"> 
                                            </div>
                                            <div class="col-md-9 form-group">
                                                <label for="invested_on">Invested On</label>
                                                <input type="date" name="invested_on[]" class="form-control"> 
                                            </div>
                                            <div class="col-md-3 form-group mt-4">
                                                <button type="button" class="btn btn-info text-white more-investors"><i class="fa-solid fa-plus"></i></button>
                                                <button type="button" class="btn btn-danger remove-investor text-white"><i class="fa-solid fa-trash"></i></button>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="text-xs-right">
                                                <button type="submit" class="btn btn-info text-white">UPDATE INVESTMENT DETAILS</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
    $(document).ready(function () {
        // Event delegation for dynamically added "More Investors" buttons
        $(document).on('click', '.more-investors', function () {
            // Clone the investment-block div
            var clonedBlock = $('.investment-block:last').clone();

            // Clear input values in the cloned block
            clonedBlock.find('input').val('');
            clonedBlock.find('select').val('');

            // Add the cloned block after the last investment-block div
            $('.investment-block:last').after(clonedBlock);

            // Display the remove-investor button in the cloned block
            clonedBlock.find('.remove-investor').show();
        });

        // Event delegation for dynamically added "Remove Investor" buttons
        $(document).on('click', '.remove-investor', function () {
            var result = confirm("Are you sure you want to remove this investor?");
            if (result) {
                // Remove the corresponding investment-block div
                $(this).closest('.investment-block').remove();
            }
        });
    });
</script>
<style>
    .remove-investor {
        display: none; /* Initially hidden */
    }
</style>
@endsection