@extends('layouts.app_backend')

@section('content')
<div class="container-full">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="callout callout-success" style="display: none;">

                </div>
                @if(session('success'))
                <div class="card card-body" id="success-card">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <strong>Success!</strong> {{ session('success') }}
                    </div>
                </div>

                <script>
                    // Auto close the success alert card after 5 seconds
                    setTimeout(function() {
                    $('#success-card').fadeOut();
                    }, 5000);
                </script>
                @endif
                <div class="box">
                    <div class="box-header with-border">
                        <div class="row justify-content-between">
                            <div class="col"><h4 class="box-title">All Deals</h4></div>
                            <div class="col-auto">
                                <a href="{{ route('admin.deals.create') }}" class="waves-effect mx-10 waves-light btn btn-sm btn-primary">ADD DEALS</a>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="investorlist" class="table table-bordered table-hover display nowrap margin-top-10 w-p100">
                                <thead>
                                    <tr class="bg-info-light">
                                        <th>No</th>
                                        <th>Deal Name</th>
                                        <th>Started On</th>
                                        <th>Total Investment</th>
                                        <th>Total Investors</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                <thead>
                                <tbody>
                                    @foreach ($deals as $deal)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><a href="{{ route('admin.deal.deatails', $deal->id) }}"><strong>{{ $deal->deal_name }}</strong></a></td>
                                        <td>{{ Carbon\Carbon::createFromFormat('Y-m-d', $deal->start_date)->format('d-m-Y') }}</td>
                                        <td>{{ number_format($deal->total_investment, 2) }}</td>
                                        <td>
                                            @php
                                            $formattedTotalInvestors = ($deal->total_investors > 0) ? $deal->total_investors : '0';
                                            echo $formattedTotalInvestors; 
                                            @endphp
                                            Invested
                                        </td>
                                        <td>
                                            <input type="hidden" id="status" name="status" value="{{ $deal->status }}">
                                            <label class="switch">
                                                <input type="checkbox" data-deal-id="{{ $deal->id }}" id="statusToggle" @if ($deal->status == 1) checked @endif onchange="updateDealStatus()">
                                                <span class="slider"></span>
                                            </label>
                                        </td>
                                        <td>
                                            <div class="d-flex">
                                                <a href="{{ route('admin.deal.deatails', $deal->id) }}" class="waves-effect waves-circle btn btn-circle btn-info-light btn-xs me-5"><i class="fa-solid fa-eye"></i></a>
                                                <a href="{{ route('admin.deals.edit', $deal->id) }}" class="waves-effect waves-circle btn btn-circle btn-success-light btn-xs me-5"><i class="fa fa-pencil"></i></a>
                                                <button type="button" class="waves-effect waves-circle btn btn-circle btn-danger-light btn-xs" onclick="confirmDelete({{ $deal->id }})">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="box-footer bg-light py-10 with-border">
                        <div class="d-flex align-items-center justify-content-between">
                            <p class="mb-0">Total {{ count($deals) }} Deals </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
<script>
    $('#investorlist').DataTable();
    function confirmDelete(dealId) {
    var confirmation = confirm("Are you sure you want to delete this Car and its details?");
    if (confirmation) {
    // User clicked "OK," navigate to the delete route
    window.location.href = "{{ route('admin.deals.destroy', '') }}/" + dealId;
    } else {
    // User clicked "Cancel," do nothing
    }
    }

    function updateDealStatus() {
    const statusToggle = document.getElementById("statusToggle");
    const currentStatus = statusToggle.checked ? 1 : 0;
    const dealId = statusToggle.getAttribute("data-deal-id");
    //console.log(dealId);

    const confirmed = confirm("Are you sure you want to update the deal status?");
    if (confirmed) {
    // Send an AJAX request to update the status in the database.
    updateStatusInDatabase(dealId, currentStatus);
    } else {
    // Restore the switch to its previous state.
    statusToggle.checked = !statusToggle.checked;
    }
    }
    function updateStatusInDatabase(dealId, newStatus) {
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    // Perform an AJAX request to update the status in the database.
    $.ajax({
    type: "POST",
            url: "{{ route('admin.deal.status') }}", // Replace with the actual URL endpoint.
            data: { _token: csrfToken, deal_id: dealId, new_status: newStatus },
            success: function(response) {
            $('.callout-success').css("display", "block");
            $('.callout-success').text(response.message);
            setTimeout(function() {
            location.reload();
            }, 2000);
            },
            error: function(error) {
            // Handle error, if needed.
            console.error(error);
            }
    });
    }

</script>
@endsection
